/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENExpressionEvaluator.h
*	\brief		Tools to compute the numeric result of a string.
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_CAENEXPRESSIONEVALUATOR_H_
#define CAEN_INCLUDE_CAENEXPRESSIONEVALUATOR_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <types/CAENExpressionEvaluatorTypes.h>
#include <CAENUtility.h>
#include <stdint.h>
#include <stddef.h>

//Substitute the 'idx' keyword with an integer number (value) in a given expression
CAEN_UTILITY_DLLAPI void CAEN_UTILITY_API c_ee_substituteIdxExpression(const char *expression, int32_t value, char *dest, size_t maxsize);

// Evaluates the expression given by 'expr'. Only integer expressions
// are supported. The integer base and formats are the ones supported
// by stdlib's function 'strtol(*,*,0)' (see strtol for description).
// Operation supported are: (+ , - , * , / , | , & , << , >>, %). Correct
// arithmetic order and parenthesys are supported. Return the result of
// expression evaluation in case of success or 0 in case of error. If the
// result of 'c_ee_exprEval' is 0, it is still possible that the result of the
// expression is 0. The user should check this with function 'c_ee_getErr()'.
CAEN_UTILITY_DLLAPI int64_t CAEN_UTILITY_API c_ee_exprEval(const char * expression);

// Return the last 'c_ee_exprEval()' error code. See enum 'c_ee_err_t'.
CAEN_UTILITY_DLLAPI c_ee_err_t CAEN_UTILITY_API c_ee_getErr(void);

// Returns a pointer to the position inside 'expr' which generated the
// error in last 'c_ee_exprEval()' call.
c_nodiscard CAEN_UTILITY_DLLAPI const char* CAEN_UTILITY_API c_ee_getErrPos(void);

// Modifies 'expression' substituting to every entry '%i' the number 'idx' and evaluates the
// expression result, filling 'result' with its value.
// NOTE: see function 'c_ee_exprEval' in module 'CAENExpressionEvaluator.c' fo a description of
// supported operations and types.
CAEN_UTILITY_DLLAPI int32_t c_ee_modifyAndEvaluateExpression(const char *expression, int32_t idx, int64_t *result);

#endif // CAEN_INCLUDE_CAENEXPRESSIONEVALUATOR_H_
