/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENSerDes.h
*	\brief		TCP/IP CAEN protocol.
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_CAENSERDES_H_
#define CAEN_INCLUDE_CAENSERDES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <types/CAENSerDesTypes.h>

#include <CAENUtility.h>
#include <types/CAENSocketTypes.h>

/*! \defgroup SerDesFunctions Serialization/deserialization protocol functions
* \brief TCP/IP protocol
*/

/*! \defgroup SendRecvPacket Specialized versions of c_recv/c_recv_unlock for CAEN protocol packets
* \ingroup SerDesFunctions
* \{ */
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API c_recv_packet(const c_socket_t *sckt, PKTHEAD_CMD_TYPE *cmd, PKTHEAD_TOTLEN_TYPE *totSize, PKTHEAD_NPARAMS_TYPE *totParams) c_attribute_malloc;
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API c_recv_packet_unlock(c_socket_t *sckt, PKTHEAD_CMD_TYPE *cmd, PKTHEAD_TOTLEN_TYPE *totSize, PKTHEAD_NPARAMS_TYPE *totParams) c_attribute_malloc;
/*! \} */

/*! \defgroup GetPacketInfo Functions to get packet info
* \ingroup SerDesFunctions
* \{ */
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API c_createheader(uint16_t version, PKTHEAD_CMD_TYPE cmd, size_t *allocatedSize);
c_nodiscard CAEN_UTILITY_DLLAPI PKTHEAD_CMD_TYPE CAEN_UTILITY_API c_getcmd(const uint8_t *buffer);
/*! \} */

/*! \defgroup SerSpecialized Serialization of base types
* \ingroup SerDesFunctions
* \{ */
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_char(const char *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_int8_t(const int8_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_uint8_t(const uint8_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_int16_t(const int16_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_uint16_t(const uint16_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_int32_t(const int32_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_uint32_t(const uint32_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_int64_t(const int64_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_uint64_t(const uint64_t *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_float(const float *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API serialize_double(const double *src, uint32_t num, uint8_t *buffer, size_t *allocSize);
/*! \} */

/*! \defgroup DesSpecialized Deserialization of base types
* \ingroup SerDesFunctions
* \{ */
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_char(char *dest, uint32_t maxnum, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int8_t(int8_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int8_t_array(int8_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint8_t(uint8_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint8_t_array(uint8_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int16_t(int16_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int16_t_array(int16_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint16_t(uint16_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint16_t_array(uint16_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int32_t(int32_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int32_t_array(int32_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint32_t(uint32_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint32_t_array(uint32_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int64_t(int64_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_int64_t_array(int64_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint64_t(uint64_t *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_uint64_t_array(uint64_t *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_float(float *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_float_array(float *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_double(double *dest, uint32_t num, uint8_t *buffer);
c_nodiscard CAEN_UTILITY_DLLAPI uint8_t * CAEN_UTILITY_API deserialize_double_array(double *dest, uint32_t maxnum, uint32_t *num, uint8_t *buffer);
/*! \} */

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_CAENSERDES_H_
