/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2014, Xsoda
*
*	This file is part of the CAEN Utility.
*
*	This file is distributed under the BSD 2-Clause "Simplified" License.
*
*	SPDX-License-Identifier: BSD-2-Clause
*
***************************************************************************//*!
*
*	\file		CAENUrl.h
*	\brief		Utilities to parse a standard URL.
*	\author		Giovanni Cerretani, Xsoda
*
******************************************************************************/

#ifndef CAEN_INCLUDE_CAENURL_H_
#define CAEN_INCLUDE_CAENURL_H_

/*!
* \defgroup ParseURL Parse URL
* \brief Utilities to parse a standard URL
* \author Xsoda
* \date 2014
* \copyright BSD 2-Clause "Simplified" License
* \{ */

#ifdef __cplusplus
extern "C" {
#endif

#include <types/CAENUrlTypes.h>
#include <CAENUtility.h>

c_nodiscard c_attribute_malloc
CAEN_UTILITY_DLLAPI c_url_field_t * CAEN_UTILITY_API c_url_parse(const char *str);

CAEN_UTILITY_DLLAPI void CAEN_UTILITY_API c_url_free(c_url_field_t *url);

/*! \} */

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_CAENURL_H_
