/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
******************************************************************************
*
*	\file		CAENAllocatorTypes.h
*	\brief		Definitions and types for CAENAllocator.h
*	\author		Francesco Pepe
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_ALLOCATORTYPES_H_
#define CAEN_INCLUDE_TYPES_ALLOCATORTYPES_H_

#include <types/CAENLinkedListTypes.h>

/*!
* \defgroup Allocator Allocator
* \brief Utilities for resource creation/destruction in C
* \author Francesco Pepe
* \date 2023
* \copyright LGPL-3.0-or-later
* \{ */

#ifdef __cplusplus
extern "C" {
#endif

typedef struct c_allocator_t {
	int32_t error_count;
	c_linkedlist_t allocated_resources;
} c_allocator_t;

typedef void(*c_resource_destroy_function)(void*);

/*! \} */

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_ALLOCATORTYPES_H_
