/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENLoggerTypes.h
*	\brief		Definitions and types for CAENLogger.h
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENLOGGERTYPES_H
#define CAEN_INCLUDE_TYPES_CAENLOGGERTYPES_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {
	c_logger_OpenMode_W    = 0,
	c_logger_OpenMode_A    = 1,
	c_logger_OpenMode_RW   = 2,
	c_logger_OpenMode_RA   = 3,
} c_logger_OpenMode_t;

typedef enum {
	c_logger_Success					=  0,
	c_logger_GenericError				= -1,
	c_logger_FilenameAlreadySet			= -2,
	c_logger_OpenmodeAlreadySet			= -3,
	c_logger_LoggerAlreadyConfigured	= -4,
	c_logger_OutOfMemory				= -5,
	c_logger_WrongOpenMode				= -6,
	c_logger_FileOpenError				= -7,
	c_logger_LoggerNotConfigured		= -8,
	c_logger_InvalidArgument			= -9,
	c_logger_LoggerAlreadyOpened		= -10,
	c_logger_LoggerOpenError			= -11,
	c_logger_LoggerStillInUse			= -12,
	c_logger_PrintError					= -13,
} c_logger_ErrorCode_t;

// NOTE, if you change the following struct, check if you have the change the lSeverityMap!!
typedef enum {
	c_logger_Severity_OFF		= 0x0,
	c_logger_Severity_ERROR		= 0x1,
	c_logger_Severity_WARNING	= 0x2,
	c_logger_Severity_INFO		= 0x4,
	c_logger_Severity_DEBUG		= 0x8,
} c_logger_Severity;

typedef struct {
	const char* const filename;
	const char* const moduletree;
} c_locallogger_t;

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENLOGGERTYPES_H

