/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2014 rxi
*
*	This file is part of the CAEN Utility.
*
*	This file is distributed under the MIT License.
*
*	SPDX-License-Identifier: MIT
*
***************************************************************************//*!
*
*	\file		CAENMapTypes.h
*	\brief		Definitions and types for CAENMAP.h
*	\author		Giovanni Cerretani, rxi
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENMAPTYPES_H_
#define CAEN_INCLUDE_TYPES_CAENMAPTYPES_H_

/*! 
* \defgroup MapFunctions Maps
* \brief Hash table implementation in C
* \author rxi
* \date 2014
* \copyright MIT license
*/

#ifdef __cplusplus
extern "C" {
#endif

#include <stdlib.h>
#include <stdbool.h>

/***************************
* Types
***************************/
struct c_map_node_t;
typedef struct c_map_node_t c_map_node_t;

//! Base type for maps. \warning Do not use directly. Instead, redefined it using c_map_t() to point to a specific type.
typedef struct {
	c_map_node_t **buckets;
	size_t nbuckets;
	size_t nnodes;
	bool initialized;
} c_map_base_t;

//! Iterator.
typedef struct {
	size_t bucketidx;
	c_map_node_t *node;
} c_map_iter_t;

/*!
* Define a new map type. To be used like:
* `typedef c_map_t(uint32_t) my_uint32map_t`;
* \param[in]		T					the type of the element to be stored
* \ingroup MapFunctions
*/
#define c_map_t(T)	struct { c_map_base_t base; T *ref; T tmp; }

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENMAPTYPES_H_
