/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENMultiplatformTypes.h
*	\brief		Definitions and types for CAENMultiplatform.h
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENMULTIPLATFORMTYPES_H_
#define CAEN_INCLUDE_TYPES_CAENMULTIPLATFORMTYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdbool.h>
#include <string.h> // memcpy, memmove, memset
#include <CAENMap.h>

#ifdef _WIN32
#include <WinSock2.h>
#include <Windows.h>
#include <io.h> // _finddata_t
#else
#include <netinet/in.h> // useful to expose macros like INADDR_ANY to users
#include <sys/types.h> // pid_t
#include <dirent.h> // DIR
#include <endian.h> // be16toh, be32toh, be64toh, ...
#include <getopt.h> // opterr, optopt, optind, ...
#endif

#ifdef _WIN32
typedef HMODULE		c_libhandle_t;
typedef FARPROC		c_fcnhandle_t;
#else
typedef void*		c_libhandle_t;
typedef void*		c_fcnhandle_t;
#endif

#define MAX_PROC_NARGS		100

#ifndef __cplusplus
#ifndef max
#define max(a,b)		(((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)		(((a) < (b)) ? (a) : (b))
#endif
#endif

#ifndef TRUE
#define TRUE			true // defined in stdbool.h
#endif
#ifndef FALSE
#define FALSE			false // defined in stdbool.h
#endif

#ifndef INFINITE
#define INFINITE		INT32_C(-1)
#endif

/*! \warning Those return value are positive to be able to
* distinguish them from the ones of the functions called.
* Called functions should instead have negative values. */
typedef enum {
	MP_code_Success = 0,          //<! Success
	MP_code_Generic = 1,          //<! Invalid Command or Command List
	MP_code_LibLoad = 2,          //<! Error loading dynamic library
	MP_code_LibClose = 3,         //<! Error closing dynamic library
} c_MP_code_t;

#ifdef _WIN32
#define DIRSEP0 "\\"
#define DIRSEP1 "/"
#define DIRSEPS {DIRSEP0, DIRSEP1}
#define DIRSEPS_CHAR {'\\', '/'}
#define DIRSEPS_STR {'\\', '/', '\0'}
#else
#define DIRSEP0 "/"
#define DIRSEPS {DIRSEP0}
#define DIRSEPS_CHAR {'/'}
#define DIRSEPS_STR {'/', '\0'}
#endif
#define DIRSEP DIRSEP0

#ifdef _WIN32 // Windows
//time struct and functions
typedef SYSTEMTIME				c_systemtime_t;

typedef ptrdiff_t				handle_type; //!< C99's intptr_t not sufficiently portable

struct dirent {
	char *d_name;
};

typedef struct {
	handle_type			handle; //!< -1 for failed rewind
	struct _finddata_t	info;
	struct dirent		result; //!< d_name null iff first time
	char				*name;  //!< null-terminated char string
} DIR;

#else // LINUX

//time struct
typedef struct {
	unsigned short wYear;
	unsigned short wMonth;
	unsigned short wDayOfWeek;
	unsigned short wDay;
	unsigned short wHour;
	unsigned short wMinute;
	unsigned short wSecond;
	unsigned short wMilliseconds;
} c_systemtime_t;
#endif

typedef enum {
	CAENPROC_RetCode_Success = 0,
	CAENPROC_RetCode_ProcessFail = -1,
	CAENPROC_RetCode_Timeout = -2,
	CAENPROC_RetCode_Generic = -3,
} CAENPROC_RetCode_t;

typedef c_map_t(char*) c_environment_t;

typedef struct {
	char *execName;
	char *argv[MAX_PROC_NARGS + 1];
	int32_t argc;
	c_environment_t environment;
#ifdef _WIN32
	DWORD lastErr;
	HANDLE jobObject;
	PROCESS_INFORMATION procInfo;
#else
	pid_t pid;
#endif
} c_Process_t;

typedef enum {
	CAEN_FP_INFINITE = 1,	//!< Corresponds to FP_INFINITE defined by math.h
	CAEN_FP_NAN = 2,		//!< Corresponds to FP_NAN defined by math.h
	CAEN_FP_NORMAL = 3,		//!< Corresponds to FP_NORMAL defined by math.h
	CAEN_FP_SUBNORMAL = 4,	//!< Corresponds to FP_SUBNORMAL defined by math.h
	CAEN_FP_ZERO = 0,		//!< Corresponds to FP_ZERO defined by math.h
} c_Float_Classification_t;

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENMULTIPLATFORMTYPES_H_
