/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENSerDesTypes.h
*	\brief		Definitions and types for CAENSerDes.h
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENSERDESTYPES_H_
#define CAEN_INCLUDE_TYPES_CAENSERDESTYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stddef.h>

//! First bytes of a packet, indicating version
#define CAEN_PKT_VERSION_MASK		(0xCAE0)
#define CAEN_PKT_VERSION(_VER)		(CAEN_PKT_VERSION_MASK | (_VER & 0xF))

typedef uint16_t				PKTHEAD_PROTOVERS_TYPE;
typedef uint32_t				PKTHEAD_TOTLEN_TYPE;
typedef uint16_t				PKTHEAD_CMD_TYPE;
typedef uint16_t				PKTHEAD_NPARAMS_TYPE;

//! The only commang code defined here, as used as return value in case of error. MUST be 0xFFFF, since used by at least by CAENMCA library.
#define CMD_INVALID_LOCAL		(PKTHEAD_CMD_TYPE)(0xFFFF)

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENSERDESTYPES_H_
