/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENSocketTypes.h
*	\brief		Definitions and types for CAENSocket.h
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENSOCKETTYPES_H_
#define CAEN_INCLUDE_TYPES_CAENSOCKETTYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _WIN32
#include <WinSock2.h>
#else
#include <sys/socket.h>
#include <errno.h>
#endif

#include <types/CAENThreadTypes.h>

typedef enum {
	c_Socket_ErrorCode_Success = 0,
	c_Socket_ErrorCode_Argument = -1,
	c_Socket_ErrorCode_GenericError = -2,
	c_Socket_ErrorCode_Init = -3,
	c_Socket_ErrorCode_Bind = -4,
	c_Socket_ErrorCode_Listen = -5,
	c_Socket_ErrorCode_Connect = -6,
	c_Socket_ErrorCode_DNS = -7,
	c_Socket_ErrorCode_Send = -8,
	c_Socket_ErrorCode_Recv = -9,
	c_Socket_ErrorCode_SocketError = -10,
	c_Socket_ErrorCode_Mutex = -11
} c_Socket_ErrorCode_t;

#ifdef _WIN32
typedef SOCKET						c_socket_type_t;	//!< Return type of socket().
typedef int							c_socklen_t;		//!< Size argument type of bind(), accept() and connect().
typedef int							c_ssize_t;			//!< Return type of send() and recv().
#define c_socket_errno				WSAGetLastError()	//!< Socket-related functions set an error retrievable from WSAGetLastError(). Type is int.
#define c_socket_h_errno			c_socket_errno		//!< Network database operations like gethostbyname() set the error into WSAGetLastError() too. Type is int.
#define c_socket_invalid			INVALID_SOCKET		//!< Functions like accept() return INVALID_SOCKET in case of error, usually a macro to -1. Type is c_socket_type_t.
#define c_socket_error				SOCKET_ERROR		//!< Functions like send() and recv() return SOCKET_ERROR in case of error, usually a macro to -1. Type is c_ssize_t.
#define c_socket_max_ssize			(size_t)INT_MAX		//!< Maximum value accepted as size by send() and recv(). Type is size_t.
#else
typedef int							c_socket_type_t;	//!< Return type of socket().
typedef socklen_t					c_socklen_t;		//!< See definition on Windows case.
typedef ssize_t						c_ssize_t;			//!< Return type of send() and recv().
#define c_socket_errno				errno				//!< Socket-related functions set the error into errno variable. Type is int.
#define c_socket_h_errno			h_errno				//!< Network database operations like gethostbyname() set the error into h_errno variable. Type is int.
#define c_socket_invalid			(-1)				//!< Functions like accept() return -1 in case of error. Type is c_socket_type_t.
#define c_socket_error				(c_ssize_t)(-1)		//!< Functions like send() and recv() return -1 in case of error. Type is c_ssize_t.
#define c_socket_max_ssize			(size_t)SSIZE_MAX	//!< Maximum value accepted as size by send() and recv(). Type is size_t.
#endif

typedef struct {
	c_socket_type_t socket; //!< The socket
	c_mutex_t mutex;		//!< A mutex, use by some functions. \see MutexSendRecv
} c_socket_t;

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENSOCKETTYPES_H_
