/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENThreadTypes.h
*	\brief		Definitions and types for CAENThreadTypes.h
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENTHREADTYPES_H_
#define CAEN_INCLUDE_TYPES_CAENTHREADTYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdbool.h>
#include <stdint.h>
#include <time.h>

#ifdef _WIN32
#include <WinSock2.h> // not needed here, but must be included before Windows.h if needed somewhere else
#include <Windows.h>
#else
#include <semaphore.h>
#include <pthread.h>
#endif

#ifdef _WIN32 // Windows
// corresponding to thrd_t, inspired to _Thrd_t on xthreads.h
struct _c_thread_t {
	HANDLE handle;
	unsigned int id;
	bool valid;
};
// Mutexes
typedef HANDLE					c_mutex_t;								//!< Mutex type
// Semaphores
typedef HANDLE					c_semaphore_t;							//!< Semaphore type
// Condition
typedef CONDITION_VARIABLE		c_conditionvariable_t;					//!< Condition variable type
#else
struct _c_thread_t {
	pthread_t handle;
	bool valid;
};
// Mutexs
typedef pthread_mutex_t			c_mutex_t;								//!< Mutex type
// Semaphores
typedef sem_t					c_semaphore_t;							//!< Semaphore type
// Conditions
typedef pthread_cond_t			c_conditionvariable_t;					//!< Condition variable type
#endif
typedef int(*					c_tstart_t				)(void*);		//!< Thread function type, as defined in C11
// Threads
typedef struct _c_thread_t		c_thread_t;								//!< Thread type

/*!
* Condition type with a mutex attached
* \brief Needed because a condition variable on Linux is associated with a mutex, while on Windows it is associated with a critical section
*/
typedef struct {
	c_conditionvariable_t	_cond;				//!< A condition variable
#ifdef _WIN32
	CRITICAL_SECTION		_critical_section;	//!< On Windows a CONDITION_VARIABLE is used with a CRITICAL_SECTION
#else
	pthread_mutex_t			_mutex;				//!< On Linux a pthread_cond_t is use with a pthread_mutex_t
#endif
} c_condition_t;

//! Ticket type
typedef struct {
	c_condition_t _condition;
	uint64_t _queue_head;
	uint64_t _queue_tail;
	c_thread_t _holding_thread_id;
} c_ticket_t;

//! Return values inspired to C11 thread.h
typedef enum {
	CAENThread_RetCode_Success = 0,
	CAENThread_RetCode_Nomem = -1,
	CAENThread_RetCode_Timedout = -2,
	CAENThread_RetCode_Busy = -3,
	CAENThread_RetCode_Error = -4,
} CAENThread_RetCode_t;

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENTHREADTYPES_H_
