/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2014, Xsoda
*
*	This file is part of the CAEN Utility.
*
*	This file is distributed under the BSD 2-Clause "Simplified" License.
*
*	SPDX-License-Identifier: BSD-2-Clause
*
***************************************************************************//*!
*
*	\file		CAENUrlTypes.h
*	\brief		Definitions and types for CAENUrl.h
*	\author		Giovanni Cerretani, Xsoda
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENURLTYPES_H_
#define CAEN_INCLUDE_TYPES_CAENURLTYPES_H_

/*!
* \defgroup ParseURL Parse URL
* \brief Utilities to parse a standard URL
* \author Xsoda
* \date 2014
* \copyright BSD 2-Clause "Simplified" License
* \{ */

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

typedef enum {
	HOST_DOMAIN,
	HOST_IPV4,
	HOST_IPV6
} c_host_type_t;

typedef struct {
	c_host_type_t host_type;
	uint32_t query_num;
	char *href;
	char *schema;
	char *username;
	char *password;
	char *host;
	char *port;
	char *path;
	struct {
		char *name;
		char *value;
	} *query;
	char *fragment;
} c_url_field_t;

/*! \} */

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENURLTYPES_H_
