/******************************************************************************
*
*	CAEN SpA - Software Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*******************************************************************************
*
*	Copyright (C) 2019-2022 CAEN SpA
*
*	This file is part of the CAEN Utility.
*
*	The CAEN Utility is free software; you can redistribute it and/or
*	modify it under the terms of the GNU Lesser General Public
*	License as published by the Free Software Foundation; either
*	version 3 of the License, or (at your option) any later version.
*
*	The CAEN Utility is distributed in the hope that it will be useful,
*	but WITHOUT ANY WARRANTY; without even the implied warranty of
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
*	Lesser General Public License for more details.
*
*	You should have received a copy of the GNU Lesser General Public
*	License along with the CAEN Utility; if not, see
*	https://www.gnu.org/licenses/.
*
*	SPDX-License-Identifier: LGPL-3.0-or-later
*
***************************************************************************//*!
*
*	\file		CAENXMLParserTypes.h
*	\brief		Definitions and types for CAENXMLParser.h
*	\author
*
******************************************************************************/

#ifndef CAEN_INCLUDE_TYPES_CAENXMLPARSERTYPES_H_
#define CAEN_INCLUDE_TYPES_CAENXMLPARSERTYPES_H_

/*!
* \defgroup XMLFunctions XML parser
* \brief Wrapper functions to libxml
*/

#ifdef __cplusplus
extern "C" {
#endif

#include <libxml/tree.h>

//! A wrapper to xmlDoc
typedef struct {
	xmlDoc *doc;	//!< the xmlDoc
	char *name;		//!< the file path (or `memory` if a memory document passed by c_xml_newfile_from_memory())
} c_xmlfile_t;

//! XML Wrapper return codes
typedef enum {
	c_xml_RetCode_Success = 0,			//!< Success
	c_xml_RetCode_GenericError = -1,	//!< Generic error
	c_xml_RetCode_NULL = -2,			//!< NULL pointer passed as argument
	c_xml_RetCode_ParseError = -3,		//!< Parser error
	c_xml_RetCode_NotFound = -4,		//!< Data not found
} c_xml_RetCode_t;

#ifdef __cplusplus
}
#endif

#endif // CAEN_INCLUDE_TYPES_CAENXMLPARSERTYPES_H_
