#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>
#include <assert.h>
#include <inttypes.h>
//! [IncludeHeader]
#include <CAENMCA.h>
//! [IncludeHeader]

void CAEN_MCA_EXAMPLES_DiscoverDevices(void);

void CAEN_MCA_EXAMPLES_GetHandles(int32_t devidx);

CAEN_MCA_HANDLE CAEN_MCA_EXAMPLES_OpenDeviceLocalhost(void);
CAEN_MCA_HANDLE CAEN_MCA_EXAMPLES_OpenDevice(const char *hostname, int32_t *idx);
void CAEN_MCA_EXAMPLES_CloseDevice(CAEN_MCA_HANDLE device);

int32_t CAEN_MCA_EXAMPLES_QuitServer(CAEN_MCA_HANDLE device);

int32_t CAEN_MCA_EXAMPLES_GetFamilyCode(CAEN_MCA_HANDLE device, CAEN_MCA_BoardFamilyCode_t *family);

int32_t CAEN_MCA_EXAMPLES_StartAcquisition(CAEN_MCA_HANDLE handle);
int32_t CAEN_MCA_EXAMPLES_StopAcquisition(CAEN_MCA_HANDLE handle);
int32_t CAEN_MCA_EXAMPLES_SetStopCriteria(CAEN_MCA_HANDLE channel, uint64_t rt, uint64_t lt, uint64_t counts_total, uint64_t counts_roi);

int32_t CAEN_MCA_EXAMPLES_GetParameterValue(CAEN_MCA_HANDLE handle, const char *codename, double *value);
int32_t CAEN_MCA_EXAMPLES_SetParameterValue(CAEN_MCA_HANDLE handle, const char *codename, double value);
int32_t CAEN_MCA_EXAMPLES_GetParameterValueList(CAEN_MCA_HANDLE handle, const char *codename, char *value, size_t valuelen);
int32_t CAEN_MCA_EXAMPLES_SetParameterValueList(CAEN_MCA_HANDLE handle, const char *codename, const char *value);

int32_t CAEN_MCA_EXAMPLES_GetParameterInfo(CAEN_MCA_HANDLE parameter);
int32_t CAEN_MCA_EXAMPLES_GetParameterCollectionInfo(CAEN_MCA_HANDLE parent_handle);

int32_t CAEN_MCA_EXAMPLES_ReadRegister(CAEN_MCA_HANDLE device, uint32_t address);

int32_t CAEN_MCA_EXAMPLES_EnableWaveforms(CAEN_MCA_HANDLE device, bool enabled);
int32_t CAEN_MCA_EXAMPLES_GetWaveforms(CAEN_MCA_HANDLE device, int32_t channel_id, int16_t *atrace1, int16_t *atrace2, uint8_t *dtrace1, uint8_t *dtrace2, uint32_t *length);

int32_t CAEN_MCA_EXAMPLES_EnableLists(CAEN_MCA_HANDLE channel, bool enabled);
int32_t CAEN_MCA_EXAMPLES_GetLists(CAEN_MCA_HANDLE channel);
int32_t CAEN_MCA_EXAMPLES_Lists_SetSaveMode(CAEN_MCA_HANDLE channel, CAEN_MCA_ListSaveMode_t mode);
int32_t CAEN_MCA_EXAMPLES_Lists_SetMaxNumberOfEvents(CAEN_MCA_HANDLE channel, uint32_t maxnevts);
int32_t CAEN_MCA_EXAMPLES_Lists_SetFilename(CAEN_MCA_HANDLE channel, const char *filename);
int32_t CAEN_MCA_EXAMPLES_Lists_SetData(CAEN_MCA_HANDLE channel, bool timetag, bool energy, bool extras);

int32_t CAEN_MCA_EXAMPLES_EnergySpectrum_GetSpectrum(CAEN_MCA_HANDLE device, int32_t channel_id, int32_t spectrum_id, uint32_t *data, uint32_t *nbins);
int32_t CAEN_MCA_EXAMPLES_EnergySpectrum_ClearSpectrum(CAEN_MCA_HANDLE energy_spectrum);
int32_t CAEN_MCA_EXAMPLES_EnergySpectrum_SetNBins(CAEN_MCA_HANDLE energy_spectrum, uint32_t nbins);
int32_t CAEN_MCA_EXAMPLES_EnergySpectrum_SetLLD(CAEN_MCA_HANDLE energy_spectrum, uint32_t lld);
int32_t CAEN_MCA_EXAMPLES_EnergySpectrum_SetULD(CAEN_MCA_HANDLE energy_spectrum, uint32_t uld);
int32_t CAEN_MCA_EXAMPLES_EnergySpectrum_SetFilename(CAEN_MCA_HANDLE energy_spectrum, const char *filename);

int32_t CAEN_MCA_EXAMPLES_GainStabilizer_EnDis(CAEN_MCA_HANDLE energy_spectrum, uint32_t enable);
int32_t CAEN_MCA_EXAMPLES_GainStabilizer_Reset(CAEN_MCA_HANDLE energy_spectrum);
int32_t CAEN_MCA_EXAMPLES_GainStabilizer_SetTimeout(CAEN_MCA_HANDLE energy_spectrum, uint32_t time);
int32_t CAEN_MCA_EXAMPLES_GainStabilizer_SetROIH(CAEN_MCA_HANDLE energy_spectrum, uint32_t roih);
int32_t CAEN_MCA_EXAMPLES_GainStabilizer_SetROIL(CAEN_MCA_HANDLE energy_spectrum, uint32_t roil);

int32_t CAEN_MCA_EXAMPLES_ROI_GetInfo(CAEN_MCA_HANDLE energy_spectrum, int32_t roi_id);
int32_t CAEN_MCA_EXAMPLES_ROI_SetLow(CAEN_MCA_HANDLE roi, uint32_t roil);
int32_t CAEN_MCA_EXAMPLES_ROI_SetHigh(CAEN_MCA_HANDLE roi, uint32_t roih);

int32_t CAEN_MCA_EXAMPLES_GetBoardInfo(CAEN_MCA_HANDLE device);
int32_t CAEN_MCA_EXAMPLES_GetChannelInfo(CAEN_MCA_HANDLE channel);

int32_t CAEN_MCA_EXAMPLES_DatabasePath(CAEN_MCA_HANDLE device, char *pathname);
int32_t CAEN_MCA_EXAMPLES_SaveConfiguration(CAEN_MCA_HANDLE device, const char *savename);
int32_t CAEN_MCA_EXAMPLES_LoadConfiguration(CAEN_MCA_HANDLE device, const char *savename);
int32_t CAEN_MCA_EXAMPLES_DeleteConfiguration(CAEN_MCA_HANDLE device, const char *savename);
int32_t CAEN_MCA_EXAMPLES_ListConfigurations(CAEN_MCA_HANDLE device);

int32_t CAEN_MCA_EXAMPLES_HVRange_GetInfo(CAEN_MCA_HANDLE hvchannel, int32_t hvrange_id);
int32_t CAEN_MCA_EXAMPLES_HVRange_GetVMon(CAEN_MCA_HANDLE hvchannel);

int32_t CAEN_MCA_EXAMPLES_HVChannel_SetStatus(CAEN_MCA_HANDLE hvchannel, bool on);
int32_t CAEN_MCA_EXAMPLES_HVChannel_SetStatusAlternative(CAEN_MCA_HANDLE hvchannel, bool on);
int32_t CAEN_MCA_EXAMPLES_HVChannel_GetStatus(CAEN_MCA_HANDLE hvchannel, bool* on);
int32_t CAEN_MCA_EXAMPLES_HVChannel_GetExtendedStatus(CAEN_MCA_HANDLE hvchannel);

int32_t CAEN_MCA_EXAMPLES_MCS_GetSpectrum(CAEN_MCA_HANDLE device, int32_t channel_id, int32_t spectrum_id, uint32_t *data, uint32_t *nbins, CAEN_MCA_MCS_Spectrum_Status_t *status, uint32_t *pass);
int32_t CAEN_MCA_EXAMPLES_MCS_SetNBins(CAEN_MCA_HANDLE mcs_spectrum, uint32_t nbins);
int32_t CAEN_MCA_EXAMPLES_MCS_SetDwellTime(CAEN_MCA_HANDLE mcs_spectrum, double value);
int32_t CAEN_MCA_EXAMPLES_MCS_GetDwellTime(CAEN_MCA_HANDLE mcs_spectrum, double *value);
int32_t CAEN_MCA_EXAMPLES_MCS_EnableHWSweep(CAEN_MCA_HANDLE mcs_spectrum, bool enabled);
int32_t CAEN_MCA_EXAMPLES_MCS_EnableSWSweep(CAEN_MCA_HANDLE mcs_spectrum, bool enabled);
int32_t CAEN_MCA_EXAMPLES_MCS_EnableHWDwell(CAEN_MCA_HANDLE mcs_spectrum, bool enabled);
int32_t CAEN_MCA_EXAMPLES_MCS_EnableSWDwell(CAEN_MCA_HANDLE mcs_spectrum, bool enabled);
int32_t CAEN_MCA_EXAMPLES_MCS_SetMode(CAEN_MCA_HANDLE mcs_spectrum, int32_t mode);
int32_t CAEN_MCA_EXAMPLES_MCS_SetAcqMode(CAEN_MCA_HANDLE mcs_spectrum, int32_t mode);
int32_t CAEN_MCA_EXAMPLES_MCS_SendSweepSignal(CAEN_MCA_HANDLE mcs_spectrum);
int32_t CAEN_MCA_EXAMPLES_MCS_ClearSpectrum(CAEN_MCA_HANDLE mcs_spectrum);
int32_t CAEN_MCA_EXAMPLES_MCS_SetPresetPasses(CAEN_MCA_HANDLE mcs_spectrum, double value);

int32_t CAEN_MCA_EXAMPLES_EnableDTSpectrum(CAEN_MCA_HANDLE device,int32_t dtspectrum_id, bool enable);
int32_t CAEN_MCA_EXAMPLES_DTSpectrum_SetRefCh(CAEN_MCA_HANDLE dt_spectrum, uint32_t refch);
int32_t CAEN_MCA_EXAMPLES_DTSpectrum_SetNBins(CAEN_MCA_HANDLE dt_spectrum, uint32_t nbins);
int32_t CAEN_MCA_EXAMPLES_DTSpectrum_SetDTStep(CAEN_MCA_HANDLE dt_spectrum, uint32_t step);
int32_t CAEN_MCA_EXAMPLES_DTSpectrum_Get(CAEN_MCA_HANDLE dt_spectrum);
int32_t CAEN_MCA_EXAMPLES_DTSpectrum_ClearSpectrum(CAEN_MCA_HANDLE dt_spectrum);