#include "examples.h"

int32_t CAEN_MCA_EXAMPLES_StartAcquisition(CAEN_MCA_HANDLE handle) {
	//! [StartAcquisition]
	int32_t ret = CAEN_MCA_SendCommand(handle, CAEN_MCA_CMD_ACQ_START, DATAMASK_CMD_NONE, DATAMASK_CMD_NONE);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}
	//! [StartAcquisition]

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_StopAcquisition(CAEN_MCA_HANDLE handle) {
	//! [StopAcquisition]
	int32_t ret = CAEN_MCA_SendCommand(handle, CAEN_MCA_CMD_ACQ_STOP, DATAMASK_CMD_NONE, DATAMASK_CMD_NONE);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}
	//! [StopAcquisition]

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_SetStopCriteria(CAEN_MCA_HANDLE channel, uint64_t rt, uint64_t lt, uint64_t counts_total, uint64_t counts_roi) {
	//! [SetStopCriteria]
	int32_t ret = CAEN_MCA_RetCode_Success;
	CAEN_MCA_HANDLE parameter;

	parameter = CAEN_MCA_GetChildHandleByName(channel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_STOP_MODE_REALTIME");
	ret |= CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)rt); // nanoseconds
	
	parameter = CAEN_MCA_GetChildHandleByName(channel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_STOP_MODE_LIVETIME");
	ret |= CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)lt); // nanoseconds

	parameter = CAEN_MCA_GetChildHandleByName(channel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_STOP_MODE_TOTAL_COUNTS");
	ret |= CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)counts_total);

	parameter = CAEN_MCA_GetChildHandleByName(channel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_STOP_MODE_COUNTS_IN_ROI");
	ret |= CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)counts_roi);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed.\n", __func__);
		ret = CAEN_MCA_RetCode_Generic;
	}
	//! [SetStopCriteria]

	return ret;
}
