#include "examples.h"

void CAEN_MCA_EXAMPLES_DiscoverDevices(void) {
	//! [DiscoverDevices]
	int32_t ret = CAEN_MCA_RetCode_Success;

	// Get the handle to the Library.
	CAEN_MCA_HANDLE library = CAEN_MCA_GetChildHandle(NULL, CAEN_MCA_HANDLE_LIBRARY, 0);

	// Set the timeout to 3000 ms
	uint64_t timeout_ms = 3000;

	ret |= CAEN_MCA_SetData(
		library,
		CAEN_MCA_DATA_DISCOVEREDDEVICES,
		DATAMASK_DISCOVERY_TIMEOUT_MS,
		timeout_ms
	);

	// Search and get the discovered devices. The function will return after 3000 ms
	uint32_t cnt_found = 0;
	char **names = malloc(DISCOVERY_LIST_MAXLEN * sizeof(*names));
	uint32_t *serial_numbers = malloc(DISCOVERY_LIST_MAXLEN * sizeof(*serial_numbers));
	char **ip_addresses = malloc(DISCOVERY_LIST_MAXLEN * sizeof(*ip_addresses));
	uint32_t *input_channels = malloc(DISCOVERY_LIST_MAXLEN * sizeof(*input_channels));
	char **model_names = malloc(DISCOVERY_LIST_MAXLEN * sizeof(*model_names));
	char **paths = malloc(DISCOVERY_LIST_MAXLEN * sizeof(*paths));

	for (int32_t i = 0; i < DISCOVERY_LIST_MAXLEN; i++) {
		if (names != NULL) names[i] = calloc(DISCOVERY_NAME_MAXLEN, sizeof(*names[i]));
		if (ip_addresses != NULL) ip_addresses[i] = calloc(DISCOVERY_IP_MAXLEN, sizeof(*ip_addresses[i]));
		if (model_names != NULL) model_names[i] = calloc(DISCOVERY_IP_MAXLEN, sizeof(*ip_addresses[i]));
		if (paths != NULL) paths[i] = calloc(DISCOVERY_IP_MAXLEN, sizeof(*ip_addresses[i]));
	}

	ret |= CAEN_MCA_GetData(
		library,
		CAEN_MCA_DATA_DISCOVEREDDEVICES,
		DATAMASK_DISCOVERY_FOUNDCOUNT |
		DATAMASK_DISCOVERY_NAME |
		DATAMASK_DISCOVERY_SERIALNUMBER |
		DATAMASK_DISCOVERY_IP |
		DATAMASK_DISCOVERY_INPUT_CHANNELS |
		DATAMASK_DISCOVERY_MODEL_NAME |
		DATAMASK_DISCOVERY_PATH,
		&cnt_found,
		names,
		serial_numbers,
		ip_addresses,
		input_channels,
		model_names,
		paths
	);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	else {
		fprintf(stdout, "Number of devices found: %"PRIu32"\n", cnt_found);

		for (uint32_t i = 0; i < cnt_found; i++) {
			// Use your results here
			fprintf(stdout, "%"PRIu32": ", i);
			fprintf(stdout, "Name: %s\t", names[i]);
			fprintf(stdout, "Model name: %s\t", model_names[i]);
			fprintf(stdout, "Serial number: %"PRIu32"\t", serial_numbers[i]);
			fprintf(stdout, "Input channels: %"PRIu32"\t", input_channels[i]);
			fprintf(stdout, "IP address: %s\t", ip_addresses[i]);
			fprintf(stdout, "Path: %s\t", paths[i]);
			fprintf(stdout, "\n");
		}
	}

	// Free data
	for (int32_t i = 0; i < DISCOVERY_LIST_MAXLEN; i++) {
		if (names != NULL) free(names[i]);
		if (ip_addresses != NULL) free(ip_addresses[i]);
		if (model_names != NULL) free(model_names[i]);
		if (paths != NULL) free(paths[i]);
	}
	free(names);
	free(ip_addresses);
	free(model_names);
	free(paths);
	//! [DiscoverDevices]
}
