#include "examples.h"


int32_t CAEN_MCA_EXAMPLES_EnableDTSpectrum(CAEN_MCA_HANDLE device,int32_t dtspectrum_id, bool enable) {

	//enable coincidence mode and set a large coincidence window
	if (enable) {
		//save board configuration before setting coincidence mode
		int32_t ret = CAEN_MCA_SendCommand(device, CAEN_MCA_CMD_CONFIGURATION_SAVE, DATAMASK_CMD_SAVE_NAME, DATAMASK_CMD_NONE, "mem_config");
		if (ret != CAEN_MCA_RetCode_Success) {
			fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
			return ret;
		}

		//! [DTEnableDisable]
		uint32_t nchannels;
		CAEN_MCA_HANDLE channel, coinc_win, neigh_coinc, coinc_mode;
		ret = CAEN_MCA_GetData(device, CAEN_MCA_DATA_BOARD_INFO, DATAMASK_BRDINFO_NCHANNELS, &nchannels);
		if (ret != CAEN_MCA_RetCode_Success) {
			fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
			return ret;
		}

		for (uint32_t ch = 0; ch < nchannels; ch++) {
			channel = CAEN_MCA_GetChildHandle(device, CAEN_MCA_HANDLE_CHANNEL, ch);
			assert(channel != NULL);
			neigh_coinc = CAEN_MCA_GetChildHandleByName(channel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_COINC_NEIGHTRG_ENABLE");
			assert(neigh_coinc != NULL);
			ret = CAEN_MCA_SetData(neigh_coinc, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, "TRUE");
			if (ret != CAEN_MCA_RetCode_Success) {
				fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
				return ret;
			}

			coinc_mode = CAEN_MCA_GetChildHandleByName(channel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_COINC_NEIGHTRG_MODE");
			assert(coinc_mode != NULL);
			ret = CAEN_MCA_SetData(coinc_mode, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, "TRG_MODE_COINC");
			if (ret != CAEN_MCA_RetCode_Success) {
				fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
				return ret;
			}

			coinc_win = CAEN_MCA_GetChildHandleByName(channel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_COINCWIN_LEN");
			assert(coinc_win != NULL);
			double length = 165000.;
			ret = CAEN_MCA_SetData(coinc_win, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, length);//window length = 165 ms 
			if (ret != CAEN_MCA_RetCode_Success) {
				fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
				return ret;
			}
		}
	}

	uint32_t enable_dt = (uint32_t)enable;

	CAEN_MCA_HANDLE dt_spectrum = CAEN_MCA_GetChildHandle(device, CAEN_MCA_HANDLE_DTSPECTRUM, dtspectrum_id);
	int32_t ret = CAEN_MCA_SetData(dt_spectrum, CAEN_MCA_DATA_DTSPECTRUM, DATAMASK_DT_SPECTRUM_ENABLE, enable_dt);
	//! [DTEnableDisable]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_DTSpectrum_SetRefCh(CAEN_MCA_HANDLE dt_spectrum, uint32_t refch) {

	//! [DTSetRefCh]
	int32_t ret = CAEN_MCA_SetData(dt_spectrum, CAEN_MCA_DATA_DTSPECTRUM, DATAMASK_DT_SPECTRUM_REFCH, refch);
	//! [DTSetRefCh]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;

}

int32_t CAEN_MCA_EXAMPLES_DTSpectrum_SetNBins(CAEN_MCA_HANDLE dt_spectrum, uint32_t nbins) {

	//! [DTSetNBins]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(dt_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_DT_SPECTRUM_NBINS");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)nbins);
	//! [DTSetNBins]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_DTSpectrum_SetDTStep(CAEN_MCA_HANDLE dt_spectrum, uint32_t step) {

	//! [DTSetTStep]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(dt_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_DT_SPECTRUM_STEP");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)step);
	//! [DTSetTStep]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_DTSpectrum_Get(CAEN_MCA_HANDLE dt_spectrum) {
	//! [DTSpectrumGet]
	uint64_t *dataarray = calloc(1, DTSPECTRUM_MAXLEN * sizeof(*dataarray));
	uint64_t ndata;
	int32_t ret = CAEN_MCA_GetData(
		dt_spectrum,
		CAEN_MCA_DATA_DTSPECTRUM,
		DATAMASK_DT_SPECTRUM_ARRAY |
		DATAMASK_DT_SPECTRUM_NENTRIES,
		dataarray,
		&ndata);
	//! [DTSpectrumGet]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
		return ret;
	}
	printf("Number of events collected %"PRIu64"\n",ndata);

	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(dt_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_DT_SPECTRUM_NBINS");
	double nbins;
	ret = CAEN_MCA_GetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, &nbins);
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
		return ret;
	}

	FILE* datafile = fopen("DTdata_to_plot.txt", "w+");
	if (datafile == NULL) {
		fprintf(stderr, "%s(): failed. Can't open file DTdata_to_plot.txt for writing. Do you have write permission on current working directory?\n", __func__);
		return CAEN_MCA_RetCode_Generic;
	}

	int start = (int)-(nbins / 2);
	for (int32_t i = 0; i < DTSPECTRUM_MAXLEN; i ++) {
		fprintf(datafile, "%d\t%"PRIu64"\n",(start +i), dataarray[i]);
	}

	fclose(datafile);
	free(dataarray);
	return ret;
}

int32_t CAEN_MCA_EXAMPLES_DTSpectrum_ClearSpectrum(CAEN_MCA_HANDLE dt_spectrum) {

	//! [ClearDTSpectrum]
	int32_t ret = CAEN_MCA_SendCommand(dt_spectrum, CAEN_MCA_CMD_DTSPECTRUM_CLEAR, DATAMASK_CMD_NONE, DATAMASK_CMD_NONE);
	//! [ClearDTSpectrum]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}