#include "examples.h"

void CAEN_MCA_EXAMPLES_GetHandles(int32_t devidx) {
	//! [Library]
	CAEN_MCA_HANDLE library = CAEN_MCA_GetChildHandle(NULL, CAEN_MCA_HANDLE_LIBRARY, 0);
	assert(library != NULL);
	//! [Library]

	//! [Device]
	CAEN_MCA_HANDLE device = CAEN_MCA_GetChildHandle(library, CAEN_MCA_HANDLE_DEVICE, devidx);
	assert(device != NULL);
	//! [Device]

	//! [GetHandle]
	CAEN_MCA_HANDLE channel_0 = CAEN_MCA_GetChildHandle(device, CAEN_MCA_HANDLE_CHANNEL, 0);
	assert(channel_0 != NULL);

	CAEN_MCA_HANDLE channel_1 = CAEN_MCA_GetChildHandle(device, CAEN_MCA_HANDLE_CHANNEL, 1);
	assert(channel_1 != NULL);
	//! [GetHandle].

	//! [GetHandleInvalid].
	CAEN_MCA_HANDLE channel_0_library = CAEN_MCA_GetChildHandle(library, CAEN_MCA_HANDLE_CHANNEL, 0);
	assert(channel_0_library == NULL);
	//! [GetHandleInvalid].

	//! [GetHandleByName1]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(channel_0, CAEN_MCA_HANDLE_PARAMETER, "PARAM_CH_THRESHOLD");
	assert(parameter != NULL);
	//! [GetHandleByName1]

	//! [GetHandleByName2]
	assert(CAEN_MCA_GetChildHandleByName(device, CAEN_MCA_HANDLE_CHANNEL, "0") == channel_0);
	assert(CAEN_MCA_GetChildHandleByName(device, CAEN_MCA_HANDLE_CHANNEL, "1") == channel_1);
	//assert(CAEN_MCA_GetChildHandleByName(NULL, CAEN_MCA_HANDLE_DEVICE, "eth://localhost") == device);
	//! [GetHandleByName2]

	//! [GetAncestorHandle1]
	assert(CAEN_MCA_GetAncestorHandle(parameter, CAEN_MCA_HANDLE_CHANNEL) == channel_0);
	assert(CAEN_MCA_GetAncestorHandle(parameter, CAEN_MCA_HANDLE_DEVICE) == device);
	//! [GetAncestorHandle1]

	//! [GetAncestorHandle2]
	assert(CAEN_MCA_GetAncestorHandle(parameter, CAEN_MCA_HANDLE_HVCHANNEL) == NULL);
	//! [GetAncestorHandle2]

	//! [GetCollection]
	CAEN_MCA_HANDLE collection = CAEN_MCA_GetChildHandle(device, CAEN_MCA_HANDLE_COLLECTION, CAEN_MCA_HANDLE_HVCHANNEL);
	assert(collection != NULL);
	//! [GetCollection]
}
