#include "examples.h"

int32_t CAEN_MCA_EXAMPLES_HVRange_GetInfo(CAEN_MCA_HANDLE hvchannel, int32_t hvrange_id) {
	//! [GetHandle]
	CAEN_MCA_HANDLE hvrange = CAEN_MCA_GetChildHandle(hvchannel, CAEN_MCA_HANDLE_HVRANGE, hvrange_id);
	//! [GetHandle]

	//! [GetInfo]
	double vset_min, vset_max, vset_incr, vmax_max;
	int32_t ret = CAEN_MCA_GetData(
		hvrange,
		CAEN_MCA_DATA_HVRANGE_INFO,
		DATAMASK_HVRANGEINFO_VSET_MIN |
		DATAMASK_HVRANGEINFO_VSET_MAX |
		DATAMASK_HVRANGEINFO_VSET_INCR |
		DATAMASK_HVRANGEINFO_VMAX_MAX,
		&vset_min,
		&vset_max,
		&vset_incr,
		&vmax_max);
	//! [GetInfo]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	else {
		fprintf(stdout, "Vset min: %f\tVset max: %f\tVset incr: %f\tVmax max %f\n", vset_min, vset_max, vset_incr, vmax_max);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_HVRange_GetVMon(CAEN_MCA_HANDLE hvchannel) {
	//! [GetActiveRange]
	CAEN_MCA_HANDLE active_range_par = CAEN_MCA_GetChildHandleByName(hvchannel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_HVCH_ACTIVE_RANGE");

	char* pvalue = malloc(PARAMINFO_NAME_MAXLEN * sizeof(*pvalue));
	int32_t ret = CAEN_MCA_GetData(active_range_par, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, pvalue);

	CAEN_MCA_HANDLE active_range = CAEN_MCA_GetChildHandleByName(hvchannel, CAEN_MCA_HANDLE_HVRANGE, pvalue);
	free(pvalue);
	//! [GetActiveRange]

	//! [GetVMon]
	CAEN_MCA_HANDLE vmon_par = CAEN_MCA_GetChildHandleByName(active_range, CAEN_MCA_HANDLE_PARAMETER, "PARAM_HVRANGE_VMON");

	double vmon;
	ret = CAEN_MCA_GetData(vmon_par, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, &vmon);
	//! [GetVMon]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	else {
		fprintf(stdout, "Vmon: %f\n", vmon);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_HVChannel_SetStatusAlternative(CAEN_MCA_HANDLE hvchannel, bool on) {
	//! [SetStatus]
	int32_t ret = CAEN_MCA_SendCommand(hvchannel, on ? CAEN_MCA_CMD_HV_ON : CAEN_MCA_CMD_HV_OFF, DATAMASK_CMD_NONE, DATAMASK_CMD_NONE);
	//! [SetStatus]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_HVChannel_SetStatus(CAEN_MCA_HANDLE hvchannel, bool on) {
	//! [SetStatusAlternative]
	uint32_t value = on;
	int32_t ret = CAEN_MCA_SendCommand(hvchannel, CAEN_MCA_CMD_HV_ONOFF, DATAMASK_CMD_HVOUTPUT_STATUS, DATAMASK_CMD_NONE, value);
	//! [SetStatusAlternative]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_HVChannel_GetStatus(CAEN_MCA_HANDLE hvchannel, bool* on) {
	//! [GetOnOff]
	uint32_t value;
	int32_t ret = CAEN_MCA_SendCommand(hvchannel, CAEN_MCA_CMD_HV_ONOFF, DATAMASK_CMD_NONE, DATAMASK_CMD_HVOUTPUT_STATUS, &value);

	*on = !!value;
	//! [GetOnOff]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_HVChannel_GetExtendedStatus(CAEN_MCA_HANDLE hvchannel) {
	//! [GetStatus]
	CAEN_MCA_HANDLE status_par = CAEN_MCA_GetChildHandleByName(hvchannel, CAEN_MCA_HANDLE_PARAMETER, "PARAM_HVCH_STATUS");

	double dstatus;
	int32_t ret = CAEN_MCA_GetData(status_par, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, &dstatus);

	uint16_t status = (uint16_t)dstatus;
	//! [GetStatus]

	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	else {
		fprintf(stdout, "Status: %"PRIx16"\n", status);
		//! [StatusMask]
		fprintf(stdout, "HV_STATUSBIT_PW: %d\n", !!(status & 0x0001));
		fprintf(stdout, "HV_STATUSBIT_RAMPUP: %d\n", !!(status & 0x0002));
		fprintf(stdout, "HV_STATUSBIT_RAMPDOWN: %d\n", !!(status & 0x0004));
		fprintf(stdout, "HV_STATUSBIT_OVCURR: %d\n", !!(status & 0x0008));
		fprintf(stdout, "HV_STATUSBIT_OVVOLT: %d\n", !!(status & 0x0010));
		fprintf(stdout, "HV_STATUSBIT_UNDVOLT: %d\n", !!(status & 0x0020));
		fprintf(stdout, "HV_STATUSBIT_MAXV: %d\n", !!(status & 0x0040));
		fprintf(stdout, "HV_STATUSBIT_MAXI: %d\n", !!(status & 0x0080));
		fprintf(stdout, "HV_STATUSBIT_TEMPWARN: %d\n", !!(status & 0x0100));
		fprintf(stdout, "HV_STATUSBIT_OVTEMP: %d\n", !!(status & 0x0200));
		fprintf(stdout, "HV_STATUSBIT_DISABLE: %d\n", !!(status & 0x0400));
		fprintf(stdout, "HV_STATUSBIT_CALIBERR: %d\n", !!(status & 0x0800)); // bit 11 is "WARMUP" on Hexagon / Red Eagle
		fprintf(stdout, "HV_STATUSBIT_RESET: %d\n", !!(status & 0x1000));
		fprintf(stdout, "HV_STATUSBIT_GOINGOFF: %d\n", !!(status & 0x2000));
		//! [StatusMask]
	}

	return ret;
}