#include "examples.h"

int32_t CAEN_MCA_EXAMPLES_EnableLists(CAEN_MCA_HANDLE channel, bool enabled) {
	//! [Enable]
	int32_t ret = CAEN_MCA_SetData(channel, CAEN_MCA_DATA_LIST_MODE, DATAMASK_LIST_ENABLE, (uint32_t)enabled);
	//! [Enable]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_Lists_SetSaveMode(CAEN_MCA_HANDLE channel, CAEN_MCA_ListSaveMode_t mode) {
	//! [SetMode]
	CAEN_MCA_ListSaveMode_t savemode = mode;
	int32_t ret = CAEN_MCA_SetData(channel, CAEN_MCA_DATA_LIST_MODE, DATAMASK_LIST_SAVEMODE, savemode);
	//! [SetMode]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_Lists_SetMaxNumberOfEvents(CAEN_MCA_HANDLE channel, uint32_t maxnevts) {
	//! [SetMaxNEvts]
	int32_t ret = CAEN_MCA_SetData(channel, CAEN_MCA_DATA_LIST_MODE, DATAMASK_LIST_MAXNEVTS, maxnevts);
	//! [SetMaxNEvts]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_Lists_SetFilename(CAEN_MCA_HANDLE channel, const char *filename) {

	int32_t ret = CAEN_MCA_SetData(channel, CAEN_MCA_DATA_LIST_MODE, DATAMASK_LIST_FILENAME, filename);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_Lists_SetData(CAEN_MCA_HANDLE channel, bool timetag, bool energy, bool extras) {
	//! [SetData]
	uint32_t mask = 0;
	if (timetag)	mask |= LIST_FILE_DATAMASK_TIMETAG;
	if (energy)		mask |= LIST_FILE_DATAMASK_ENERGY;
	if (extras)		mask |= LIST_FILE_DATAMASK_FLAGS;

	int32_t ret = CAEN_MCA_SetData(channel, CAEN_MCA_DATA_LIST_MODE, DATAMASK_LIST_FILE_DATAMASK, mask);
	//! [SetData]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_GetLists(CAEN_MCA_HANDLE channel) {
	//! [GetLists]
	uint32_t maxnevts;
	uint32_t nevts;
	uint32_t getfake, getsat, getskim;
	CAEN_MCA_ListSaveMode_t savemode;
	uint32_t enabled;
	uint32_t datamask;
	char *filename = malloc(LISTS_FULLPATH_MAXLEN * sizeof(*filename));
	uint64_t *datatimetag = malloc(LISTS_DATA_MAXLEN * sizeof(*datatimetag));
	uint16_t *dataenergy = malloc(LISTS_DATA_MAXLEN * sizeof(*dataenergy));
	uint32_t *dataflags = malloc(LISTS_DATA_MAXLEN * sizeof(*dataflags));

	int32_t ret = CAEN_MCA_GetData(
		channel,
		CAEN_MCA_DATA_LIST_MODE,
		DATAMASK_LIST_ENABLE |
		DATAMASK_LIST_SAVEMODE |
		DATAMASK_LIST_FILENAME |
		DATAMASK_LIST_FILE_DATAMASK |
		DATAMASK_LIST_GETFAKEEVTS |
		DATAMASK_LIST_MAXNEVTS |
		DATAMASK_LIST_NEVTS |
		DATAMASK_LIST_DATA_TIMETAG |
		DATAMASK_LIST_DATA_ENERGY |
		DATAMASK_LIST_DATA_FLAGS_DATAMASK |
		DATAMASK_LIST_GETSATEVTS |
		DATAMASK_LIST_GETSKIMEVTS,
		&enabled,
		&savemode,
		filename,
		&datamask,
		&getfake,
		&maxnevts,
		&nevts,
		datatimetag,
		dataenergy,
		dataflags,
		&getsat,
		&getskim
	);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	else {
		fprintf(stdout, "Enabled: %"PRIu32"\n", enabled);

		fprintf(stdout, "Save mode: ");
		switch (savemode) {
		case CAEN_MCA_SAVEMODE_FILE_ASCII: fprintf(stdout, "File (ASCII)\n"); break;
		case CAEN_MCA_SAVEMODE_FILE_BINARY: fprintf(stdout, "File (binary)\n"); break;
		case CAEN_MCA_SAVEMODE_MEMORY: fprintf(stdout, "Memory\n"); break;
		}

		fprintf(stdout, "Get fake events: %s\n", getfake ? "true" : "false");

		bool timetag = datamask & LIST_FILE_DATAMASK_TIMETAG;
		bool energy = datamask & LIST_FILE_DATAMASK_ENERGY;
		bool extras = datamask & LIST_FILE_DATAMASK_FLAGS;

		fprintf(stdout, "Data mask (for file modes): ");
		fprintf(stdout, "Timetag (%s)\t", timetag ? "true" : "false");
		fprintf(stdout, "Energy (%s)\t", energy ? "true" : "false");
		fprintf(stdout, "Extras (%s)\t", extras ? "true" : "false");
		fprintf(stdout, "\n");

		fprintf(stdout, "Filename: %s\n", filename);

		fprintf(stdout, "Events: %"PRIu32" (max: %"PRIu32")\n", nevts, maxnevts);

		fprintf(stdout, "First 10 events received:\n");
		for (uint32_t i = 0; i < nevts && i < 10; i++) {
			fprintf(stdout, "\t#%"PRIu32":", i);
			fprintf(stdout, "\tTimetag: %"PRIu64"", datatimetag[i]);
			fprintf(stdout, "\tEnergy: %"PRIu32"", dataenergy[i]);
			fprintf(stdout, "\tFlags: 0x%08"PRIx16"", dataflags[i]);
			fprintf(stdout, "\n");
		}
	}

	free(datatimetag);
	free(dataenergy);
	free(dataflags);
	free(filename);
	//! [GetLists]

	return ret;
}
