#include "examples.h"


int32_t CAEN_MCA_EXAMPLES_MCS_GetSpectrum(CAEN_MCA_HANDLE device, int32_t channel_id, int32_t spectrum_id, uint32_t *data, uint32_t *nbins, CAEN_MCA_MCS_Spectrum_Status_t *status, uint32_t *pass) {
	//! [GetHandle]
	CAEN_MCA_HANDLE channel = CAEN_MCA_GetChildHandle(device, CAEN_MCA_HANDLE_CHANNEL, channel_id);
	CAEN_MCA_HANDLE mcs_spectrum = CAEN_MCA_GetChildHandle(channel, CAEN_MCA_HANDLE_MCSSPECTRUM, spectrum_id);
	//! [GetHandle]

	//! [GetSpectrum]
	int32_t ret = CAEN_MCA_RetCode_Success;

	// Initialize variables
	double nchannels;
	uint32_t *dataarray = malloc(MCSSPECTRUM_MAXLEN * sizeof(*dataarray));
	uint8_t spe_status;
	uint32_t pass_number;

	// Get number of bins as parameter
	CAEN_MCA_HANDLE *parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_CHANNELS");

	ret |= CAEN_MCA_GetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, &nchannels);

	// Get mcs data
	ret |= CAEN_MCA_GetData(mcs_spectrum,
		CAEN_MCA_DATA_MCSSPECTRUM,
		DATAMASK_MCS_SPECTRUM_ARRAY |
		DATAMASK_MCS_SPECTRUM_STATUS |
		DATAMASK_MCS_SPECTRUM_CURRENT_PASS,
		dataarray,
		&spe_status,
		&pass_number
	);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}
	else {
		if (data != NULL && nbins != NULL) {
			*nbins = (uint32_t)nchannels;
			memcpy(data, dataarray, *nbins * sizeof(*data));
			*status = (CAEN_MCA_MCS_Spectrum_Status_t)spe_status;
			*pass = pass_number;
		}

		fprintf(stdout, "Number of bins: %"PRIu32"\n", (uint32_t)nchannels);
	}

	free(dataarray);
	//! [GetSpectrum]

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_SetNBins(CAEN_MCA_HANDLE mcs_spectrum, uint32_t nbins) {

	//! [SetNBins]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_CHANNELS");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)nbins);
	//! [SetNBins]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_SetDwellTime(CAEN_MCA_HANDLE mcs_spectrum, double value) {
	//! [SetDwell]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_DWELL_TIME");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)value);
	//! [SetDwell]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_GetDwellTime(CAEN_MCA_HANDLE mcs_spectrum, double *value) {

	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_DWELL_TIME");

	int32_t ret = CAEN_MCA_GetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, value);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_EnableSWDwell(CAEN_MCA_HANDLE mcs_spectrum, bool enabled) {
	char *value = calloc(PARAMINFO_NAME_MAXLEN, sizeof(*value));

	if (enabled)
		strncpy(value, "TRUE", sizeof(value) - 1);
	else
		strncpy(value, "FALSE", sizeof(value) - 1);

	//! [EnableDisableDS]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_SW_DWELL_ENABLE");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, value);
	//! [EnableDisableDS]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	free(value);

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_EnableHWDwell(CAEN_MCA_HANDLE mcs_spectrum, bool enabled) {
	char *value = calloc(PARAMINFO_NAME_MAXLEN, sizeof(*value));

	if (enabled)
		strncpy(value, "TRUE", sizeof(value) - 1);
	else
		strncpy(value, "FALSE", sizeof(value) - 1);

	//! [EnableDisableDH]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_HW_DWELL_ENABLE");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, value);
	//! [EnableDisableDH]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	free(value);

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_EnableSWSweep(CAEN_MCA_HANDLE mcs_spectrum, bool enabled) {
	char *value = calloc(PARAMINFO_NAME_MAXLEN, sizeof(*value));

	if (enabled)
		strncpy(value, "TRUE", sizeof(value) - 1);
	else
		strncpy(value, "FALSE", sizeof(value) - 1);

	//! [EnableDisableSS]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_SW_SWEEP_ENABLE");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, value);
	//! [EnableDisableSS]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	free(value);

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_EnableHWSweep(CAEN_MCA_HANDLE mcs_spectrum, bool enabled) {
	char *value = calloc(PARAMINFO_NAME_MAXLEN, sizeof(*value));

	if (enabled)
		strncpy(value, "TRUE", sizeof(value) - 1);
	else
		strncpy(value, "FALSE", sizeof(value) - 1);

	//! [EnableDisableSH]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_HW_SWEEP_ENABLE");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, value);
	//! [EnableDisableSH]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	free(value);

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_SetMode(CAEN_MCA_HANDLE mcs_spectrum, int32_t mode) {
	//! [SetMode]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_MODE");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)mode);
	//! [SetMode]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_SetAcqMode(CAEN_MCA_HANDLE mcs_spectrum, int32_t mode) {
	//! [SetAcqMode]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_ACQ_MODE");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)mode);
	//! [SetAcqMode]
	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}


int32_t CAEN_MCA_EXAMPLES_MCS_SendSweepSignal(CAEN_MCA_HANDLE mcs_spectrum) {

	//! [Sweep]
	int32_t ret = CAEN_MCA_SendCommand(mcs_spectrum, CAEN_MCA_CMD_MCS_SWEEP, DATAMASK_CMD_NONE, DATAMASK_CMD_NONE);
	//! [Sweep]
	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_ClearSpectrum(CAEN_MCA_HANDLE mcs_spectrum) {
	//! [Clear]
	int32_t ret = CAEN_MCA_SendCommand(mcs_spectrum, CAEN_MCA_CMD_MCS_SPECTRUM_CLEAR, DATAMASK_CMD_NONE, DATAMASK_CMD_NONE);
	//! [Clear]
	if (ret != CAEN_MCA_RetCode_Success) {
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_MCS_SetPresetPasses(CAEN_MCA_HANDLE mcs_spectrum, double value) {

	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(mcs_spectrum, CAEN_MCA_HANDLE_PARAMETER, "PARAM_MCS_PRESET_PASSES");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)value);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}
