#include "examples.h"

int32_t CAEN_MCA_EXAMPLES_ROI_GetInfo(CAEN_MCA_HANDLE spectrum, int32_t roi_id) {
	//! [GetHandle]
	CAEN_MCA_HANDLE roi = CAEN_MCA_GetChildHandle(spectrum, CAEN_MCA_HANDLE_ROI, roi_id);
	//! [GetHandle]

	//! [GetROI]
	uint64_t roi_nentries;
	int32_t ret = CAEN_MCA_GetData(roi, CAEN_MCA_DATA_ROI, DATAMASK_ROI_NENTRIES, &roi_nentries);
	//! [GetROI]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	else {
		fprintf(stdout, "ROI entries: %"PRIu64"\n", roi_nentries);
	}

	return ret;

}

int32_t CAEN_MCA_EXAMPLES_ROI_SetLow(CAEN_MCA_HANDLE roi, uint32_t roil) {

	//! [SetLow]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(roi, CAEN_MCA_HANDLE_PARAMETER, "PARAM_ROI_LOW");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)roil);
	//! [SetLow]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_ROI_SetHigh(CAEN_MCA_HANDLE roi, uint32_t roih) {

	//! [SetHigh]
	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(roi, CAEN_MCA_HANDLE_PARAMETER, "PARAM_ROI_HIGH");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, (double)roih);
	//! [SetHigh]

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	return ret;
}
