#include "examples.h"

int32_t CAEN_MCA_EXAMPLES_EnableWaveforms(CAEN_MCA_HANDLE device, bool enabled) {
	//! [EnableWaveforms]
	char *value = calloc(PARAMINFO_NAME_MAXLEN, sizeof(*value));

	if (enabled)
		strncpy(value, "TRUE", PARAMINFO_NAME_MAXLEN - 1);
	else
		strncpy(value, "FALSE", PARAMINFO_NAME_MAXLEN - 1);

	CAEN_MCA_HANDLE *parameter = CAEN_MCA_GetChildHandleByName(device, CAEN_MCA_HANDLE_PARAMETER, "PARAM_WAVEFORMS");

	int32_t ret = CAEN_MCA_SetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_CODENAME, value);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}
	free(value);
	//! [EnableWaveforms]

	return ret;
}

int32_t CAEN_MCA_EXAMPLES_GetWaveforms(CAEN_MCA_HANDLE device, int32_t channel_id, int16_t *atrace1, int16_t *atrace2, uint8_t *dtrace1, uint8_t *dtrace2, uint32_t *len) {
	//! [GetWaveforms]
	int32_t ret = CAEN_MCA_RetCode_Success;

	CAEN_MCA_HANDLE parameter = CAEN_MCA_GetChildHandleByName(device, CAEN_MCA_HANDLE_PARAMETER, "PARAM_RECLEN");

	// To get the number of sample, we need the record length and the sample period
	uint32_t length = 0;

	// Get record length (in ns)
	double rl;
	ret |= CAEN_MCA_GetData(parameter, CAEN_MCA_DATA_PARAMETER_VALUE, DATAMASK_VALUE_NUMERIC, &rl);

	// Get sample period (in ps)
	uint32_t tsample_ps;
	ret |= CAEN_MCA_GetData(device, CAEN_MCA_DATA_BOARD_INFO, DATAMASK_BRDINFO_TSAMPLE_PS, &tsample_ps);

	// Get waveforms
	CAEN_MCA_HANDLE channel = CAEN_MCA_GetChildHandle(device, CAEN_MCA_HANDLE_CHANNEL, channel_id);

	ret |= CAEN_MCA_GetData(
		channel,
		CAEN_MCA_DATA_WAVEFORM,
		DATAMASK_WAVEFORM_TRACE1 |
		DATAMASK_WAVEFORM_TRACE2 |
		DATAMASK_WAVEFORM_DTRACE1 |
		DATAMASK_WAVEFORM_DTRACE2,
		atrace1,
		atrace2,
		dtrace1,
		dtrace2
	);

	if (ret != CAEN_MCA_RetCode_Success) {
		// Error
		fprintf(stderr, "%s(): failed. Error: '%"PRIi32"'.\n", __func__, ret);
	}

	else {
		length = (uint32_t)rl * 1000 / tsample_ps;
	}
	//! [GetWaveforms]

	if (len != NULL) *len = length;

	return ret;
}
