/******************************************************************************
*
*	CAEN SpA - Front End Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*	This file is part of CAEN MCA which is released under
*	GNU Lesser General Public License. See file doc/README.md
*	or go to https://www.gnu.org/licenses/ for full license details.
*
***************************************************************************//*!
*
*	\file		MCALIB_Discovery.h
*	\brief		SSDP discovery tools
*	\author		Giovanni Cerretani, Lara Palla, Francesco Pepe
*	\version	0.99.11
*	\date		2023
*	\copyright	GNU Lesser General Public License
*
******************************************************************************/

/******************************************************************************
* Tools for discover Hexagon devices using the SSDP protocol.
*
* On Windows it is done using the COM library.
* The method is inspired to a Microsoft example:
*		Source:		https://github.com/Microsoft/Windows-classic-samples/blob/master/Samples/Win7Samples/winbase/DeviceFoundation/FunctionDiscovery/Client/FunDiscovery.cpp
*		License:	MIT license
*		Year:		2018
*		Author:		Microsoft Corporation
*
* On Linux it is done using the GSSDP library. GSSDP is loaded at runtime and its headers are needed only to compile this library.
* The method is inspired to a GSSDP example:
*		Source:		https://github.com/GNOME/gssdp/blob/master/examples/test-browser.c
*		License:	GNU Library General Public License
*		Year:		2014
*		Author:		Jorn Baayen
*
******************************************************************************/
#ifndef _MCALIB_DISCOVERY_H
#define _MCALIB_DISCOVERY_H

#include <MCALIB_Common.h>

#define SSDP_DEFAULT_TIMEOUT_MS				(5000)
#define SSDP_HEXAGON_FILENAME				"hexagon.xml"

#ifndef _WIN32
void MCALIB_LoadGSSDPLibraries(void);
void MCALIB_CloseGSSDPLibraries(void);
#endif

int32_t MCALIB_SetDiscoveredDevices(const MCALIB_Handle_t *handle, uint64_t dataMask, va_list args);
int32_t MCALIB_GetDiscoveredDevices(const MCALIB_Handle_t *handle, uint64_t dataMask, va_list args);

#endif // _MCALIB_DISCOVERY_H
