/******************************************************************************
*
*	CAEN SpA - Front End Division
*	Via Vetraia, 11 - 55049 - Viareggio ITALY
*	+39 0594 388 398 - www.caen.it
*
*	This file is part of CAEN MCA which is released under
*	GNU Lesser General Public License. See file doc/README.md
*	or go to https://www.gnu.org/licenses/ for full license details.
*
***************************************************************************//*!
*
*	\file		MCALIB_SharedClientServer.h
*	\brief		Macros and definitions to share with the server
*	\author		Giovanni Cerretani, Lara Palla, Francesco Pepe
*	\version	0.99.11
*	\date		2023
*	\copyright	GNU Lesser General Public License
*
******************************************************************************/
#ifndef _MCALIB_SHAREDCLIENTSERVER_H
#define _MCALIB_SHAREDCLIENTSERVER_H

#include <stdint.h>

/*! \defgroup CommandCodes Command Codes
*  \brief Codes for client/server communication
*  \{
*/
#define CMD_GLOBAL_STAT_GET							(0)
#define CMD_GLOBAL_TRG_AUTOMODE_SET					(1)
#define CMD_GLOBAL_TRG_AUTOMODE_GET					(2)
#define CMD_BOARD_ADD								(3)
#define CMD_BOARD_STAT_GET							(4)
#define CMD_BOARD_INFO_GET							(5)
#define CMD_BOARD_REGISTER_WRITE					(6)
#define CMD_BOARD_REGISTER_READ						(7)
#define CMD_CHANNEL_ACQ_START						(8)
#define CMD_CHANNEL_ACQ_STOP						(9)
#define CMD_CHANNEL_STAT_GET						(10)
#define CMD_CHANNEL_ACQ_MODE_SET					(11)
#define CMD_CHANNEL_ACQ_MODE_GET					(12)
#define CMD_PARAMETER_SET							(13)
#define CMD_PARAMETER_GET							(14)
#define CMD_PARAMETER_INFO_GET						(15)
#define CMD_PARAMETER_AUTOCALIB_START				(16)
#define CMD_PARAMETER_AUTOCALIB_STATUS_GET			(17)
#define CMD_PARAMETER_AUTOCALIB_RESULT_GET			(18)
#define CMD_PARAMETER_AUTOCALIB_STOP				(19)
#define CMD_BOARD_REMOVE_ALL						(20)
#define CMD_BOARD_ADD_FILE							(21)
#define CMD_GLOBAL_RUN_SAVE							(22)
#define CMD_GLOBAL_RUN_LOAD							(23)
#define CMD_GLOBAL_RUN_LIST							(24)
#define CMD_GLOBAL_QUIT								(25)
#define CMD_GLOBAL_DEFINITIONS_GET					(26)
#define CMD_ENERGY_SPECTRUM_GET						(27)
#define CMD_ENERGY_SPECTRUM_SET						(28)
#define CMD_ENERGY_SPECTRUM_CLEAR					(29)
#define CMD_WAVEFORM_GET							(30)
#define CMD_GLOBAL_CONFIG_SAVE						(31)
#define CMD_GLOBAL_CONFIG_LOAD						(32)
#define CMD_GLOBAL_CONFIG_LIST						(33)
#define CMD_GLOBAL_CONFIG_DELETE					(34)
#define CMD_LIST_SET								(35)
#define CMD_LIST_GET								(36)
#define CMD_HVCHANNEL_INFO_GET						(37)
#define CMD_HVRANGE_INFO_GET						(38)
#define CMD_PARAM_AUTOSET_START						(39)
#define CMD_PARAM_AUTOSET_STOP						(40)
#define CMD_CHANNEL_INFO_GET						(41)
#define CMD_ROI_INFO_GET							(42)
#define CMD_HVCHANNEL_ON							(43)
#define CMD_HVCHANNEL_OFF							(44)
#define CMD_HVCHANNEL_ONOFF							(45)
#define CMD_MCS_SPECTRUM_GET						(46)
#define CMD_MCS_SWEEP								(47)
#define CMD_MCS_SPECTRUM_CLEAR						(48)
#define CMD_GAIN_STABILIZER_RESET					(49)
#define CMD_DT_SPECTRUM_GET							(50)
#define CMD_DT_SPECTRUM_SET							(51)
#define CMD_DT_SPECTRUM_CLEAR						(52)
#define CMD_SAMPLE_ADVANCE							(53)
#define CMD_STARTUP_NOTIFICATION					(54)
#define CMD_GLOBAL_DATABASE_PATH					(55)
#define CMD_RTCLOCK_DATETIME						(56)
#define CMD_INVALID									(0xFFFF)
/*! \} */

// Other defines that was previously in CAENMCATypes.h. Moved here to
// keep using them as define internally (for static allocs, etc),
// adding a _DEF postfix. CAENMCATypes.h will define 'extern int32_t'
// values filled with a macro defined in this file. MCALib must then
// call such macro in one of its .c file. This allows to change such
// values between different MCALib's versions.

#define CAEN_MCA_DEFAULT_TCP_PORT_DEF					UINT16_C(56342)
#define PARAMINFO_LIST_MAXLEN_DEF						(20)
#define HANDLE_NAME_MAXLEN_DEF							(48)
#define PARAMINFO_NAME_MAXLEN_DEF						(HANDLE_NAME_MAXLEN_DEF)
#define HVRANGEINFO_NAME_MAXLEN_DEF						(HANDLE_NAME_MAXLEN_DEF)
#define MODEL_NAME_MAXLEN_DEF							(12)
#define LICENSE_MAXLEN_DEF								(17)
#define VERSION_MAXLEN_DEF								(20)
#define LIB_VERSION_MAXLEN_DEF							(VERSION_MAXLEN_DEF)
#define ENERGYSPECTRUM_MAXLEN_DEF						(32768)
#define WAVEFORM_MAXLEN_DEF								(131072)
#define DEFINITIONARRAY_MAXLEN_DEF						(65536)
#define CONFIGSAVE_NAME_MAXLEN_DEF						(48)
#define CONFIGSAVE_LIST_MAXLEN_DEF						(200)
#define HEXAGONDISCOVERY_NAME_MAXLEN_DEF				(150)
#define HEXAGONDISCOVERY_LIST_MAXLEN_DEF				(20)
#define HEXAGONDISCOVERY_IP_MAXLEN_DEF					(22)		//!< See the "INET_ADDRSTRLEN" macro for details
#define LISTS_DATA_MAXLEN_DEF							(65536)
#define COLLECTION_MAXLEN_DEF							(1024)
#define MCSSPECTRUM_MAXLEN_DEF							(32768)
#define DTSPECTRUM_MAXLEN_DEF							(4096)
#define STANDARD_FILE_MAXLEN_DEF						(200)
#define BASEDIR_MAXLEN_DEF								(STANDARD_FILE_MAXLEN_DEF)
#define RUNSAVE_RELATIVEPATH_MAXLEN_DEF					(STANDARD_FILE_MAXLEN_DEF)
#define RUNSAVE_FULLPATH_MAXLEN_DEF						(BASEDIR_MAXLEN_DEF + 1 + RUNSAVE_RELATIVEPATH_MAXLEN_DEF)
#define ENERGYSPECTRUM_RELATIVEPATH_MAXLEN_DEF			(STANDARD_FILE_MAXLEN_DEF)
#define ENERGYSPECTRUM_FULLPATH_MAXLEN_DEF				(BASEDIR_MAXLEN_DEF + 1 + ENERGYSPECTRUM_RELATIVEPATH_MAXLEN_DEF)
#define CONFIGSAVE_RELATIVEPATH_MAXLEN_DEF				(STANDARD_FILE_MAXLEN_DEF)
#define CONFIGSAVE_FULLPATH_MAXLEN_DEF					(BASEDIR_MAXLEN_DEF + 1 + CONFIGSAVE_RELATIVEPATH_MAXLEN_DEF)
#define LISTS_RELATIVEPATH_MAXLEN_DEF					(STANDARD_FILE_MAXLEN_DEF)
#define LISTS_FULLPATH_MAXLEN_DEF						(BASEDIR_MAXLEN_DEF + 1 + LISTS_RELATIVEPATH_MAXLEN_DEF)
#define SAMPLEID_MAXLEN_DEF								(100)
#define DATETIME_MAXLEN_DEF								(20)

#define MCALIB_CONSTANT(NAME) int32_t NAME = NAME ## _DEF

#define DEFINE_MCALIB_CONSTANTS() \
	MCALIB_CONSTANT(CAEN_MCA_DEFAULT_TCP_PORT); \
	MCALIB_CONSTANT(PARAMINFO_LIST_MAXLEN); \
	MCALIB_CONSTANT(HANDLE_NAME_MAXLEN); \
	MCALIB_CONSTANT(PARAMINFO_NAME_MAXLEN); \
	MCALIB_CONSTANT(HVRANGEINFO_NAME_MAXLEN); \
	MCALIB_CONSTANT(MODEL_NAME_MAXLEN); \
	MCALIB_CONSTANT(LICENSE_MAXLEN); \
	MCALIB_CONSTANT(VERSION_MAXLEN); \
	MCALIB_CONSTANT(LIB_VERSION_MAXLEN); \
	MCALIB_CONSTANT(ENERGYSPECTRUM_MAXLEN); \
	MCALIB_CONSTANT(WAVEFORM_MAXLEN); \
	MCALIB_CONSTANT(DEFINITIONARRAY_MAXLEN); \
	MCALIB_CONSTANT(CONFIGSAVE_NAME_MAXLEN); \
	MCALIB_CONSTANT(CONFIGSAVE_LIST_MAXLEN); \
	MCALIB_CONSTANT(HEXAGONDISCOVERY_NAME_MAXLEN); \
	MCALIB_CONSTANT(HEXAGONDISCOVERY_LIST_MAXLEN); \
	MCALIB_CONSTANT(HEXAGONDISCOVERY_IP_MAXLEN); \
	MCALIB_CONSTANT(LISTS_DATA_MAXLEN); \
	MCALIB_CONSTANT(COLLECTION_MAXLEN); \
	MCALIB_CONSTANT(MCSSPECTRUM_MAXLEN); \
	MCALIB_CONSTANT(DTSPECTRUM_MAXLEN); \
	MCALIB_CONSTANT(STANDARD_FILE_MAXLEN); \
	MCALIB_CONSTANT(BASEDIR_MAXLEN); \
	MCALIB_CONSTANT(RUNSAVE_RELATIVEPATH_MAXLEN); \
	MCALIB_CONSTANT(RUNSAVE_FULLPATH_MAXLEN); \
	MCALIB_CONSTANT(ENERGYSPECTRUM_RELATIVEPATH_MAXLEN); \
	MCALIB_CONSTANT(ENERGYSPECTRUM_FULLPATH_MAXLEN); \
	MCALIB_CONSTANT(CONFIGSAVE_RELATIVEPATH_MAXLEN); \
	MCALIB_CONSTANT(CONFIGSAVE_FULLPATH_MAXLEN); \
	MCALIB_CONSTANT(LISTS_RELATIVEPATH_MAXLEN); \
	MCALIB_CONSTANT(LISTS_FULLPATH_MAXLEN); \
	MCALIB_CONSTANT(SAMPLEID_MAXLEN); \
	MCALIB_CONSTANT(DATETIME_MAXLEN)

//! Board info struct
typedef struct {
	char ModelName[MODEL_NAME_MAXLEN_DEF];
	int32_t Model;
	uint32_t nChannels;
	uint32_t nHVChannels;
	uint32_t nLVDSGroups;
	uint32_t nVirtualTraces;
	uint32_t nMonOuts;
	uint32_t nDTSpectra;
	uint16_t ROC_FW_Maj;
	uint16_t ROC_FW_Min;
	uint16_t ROC_FW_Build;
	uint16_t AMC_FW_Maj;
	uint16_t AMC_FW_Min;
	uint16_t AMC_FW_Build;
	char License[LICENSE_MAXLEN_DEF];
	uint32_t SerialNum;
	int32_t FamilyCode;
	int32_t FormFactor;
	uint32_t PCBRevision;
	uint32_t ADC_NBits;
	uint32_t TSample_ps;
	uint32_t Energy_NBits;
	char LibVersion[LIB_VERSION_MAXLEN_DEF];
} HexagonServer_BoardInfo_t;

//! Server return codes
typedef enum {
	HexagonServer_RetCode_Success = 0,
	HexagonServer_RetCode_Generic = -1,
	HexagonServer_RetCode_SockInit = -2,
	HexagonServer_RetCode_SockListen = -3,
	HexagonServer_RetCode_SockAccept = -4,
	HexagonServer_RetCode_Serialize = -5,
	HexagonServer_RetCode_Deserialize = -6,
	HexagonServer_RetCode_OpenDigitizer = -7,
	HexagonServer_RetCode_Communication = -8,
	HexagonServer_RetCode_Command = -9,
	HexagonServer_RetCode_Parameter = -10,
	HexagonServer_RetCode_Handle = -11,
	HexagonServer_RetCode_BoardsNum = -12,
	HexagonServer_RetCode_Lock = -13,
	HexagonServer_RetCode_Unlock = -14,
	HexagonServer_RetCode_Channel = -15,
	HexagonServer_RetCode_DPPCode = -16,
	HexagonServer_RetCode_NULL = -17,
	HexagonServer_RetCode_RunNum = -18,
	HexagonServer_RetCode_Bounds = -19,
	HexagonServer_RetCode_DumpMode = -20,
	HexagonServer_RetCode_Ready = -21,				//!< Digitizer not ready
	HexagonServer_RetCode_LVDSGroup = -22,
	HexagonServer_RetCode_DumperVersion = -23,
	HexagonServer_RetCode_DumperInfos = -24,
	HexagonServer_RetCode_HWControl = -25,
	HexagonServer_RetCode_DumpOpen = -26,
	HexagonServer_RetCode_DumpClose = -27,
	HexagonServer_RetCode_FilePresence = -28,
	HexagonServer_RetCode_PathCreate = -29,
	HexagonServer_RetCode_InvalidRunName = -30,
	HexagonServer_RetCode_DigitizerInit = -31,
	HexagonServer_RetCode_VirtualTrace = -32,
	HexagonServer_RetCode_Argument = -33,
	HexagonServer_RetCode_FileRead = -34,
	HexagonServer_RetCode_FileWrite = -35,
	HexagonServer_RetCode_FileOpen = -36,
	HexagonServer_RetCode_ParameterValue = -37,
	HexagonServer_RetCode_NotYetImplemented = -38,
	HexagonServer_RetCode_EnergySpectrum = -39,
	HexagonServer_RetCode_Waveform = -40,
	HexagonServer_RetCode_OutOfMemory = -41,
	HexagonServer_RetCode_HVChannel = -42,
	HexagonServer_RetCode_SQLite = -43,
	HexagonServer_RetCode_Lists = -44,
	HexagonServer_RetCode_HVRange = -45,
	HexagonServer_RetCode_ROI = -45,
	HexagonServer_RetCode_Refused = -46,
	HexagonServer_RetCode_LowStats = -47,
	HexagonServer_RetCode_DT_Spectrum = -48,
} HexagonServer_RetCode_t;

// XML Parameter definitions
#define XML_BOARD_PARAMS_KEY						"SRVBoardParameters"
#define XML_CHANNEL_PARAMS_KEY						"SRVChannelParameters"
#define XML_ENERGYSPECTRUM_PARAMS_KEY				"SRVEnergySpectrumParameters"
#define XML_MCSSPECTRUM_PARAMS_KEY					"SRVMCSSpectrumParameters"
#define XML_ROI_PARAMS_KEY							"SRVROIParameters"
#define XML_HVCHANNEL_PARAMS_KEY					"SRVHVChannelParameters"
#define XML_HVRANGE_PARAMS_KEY						"SRVHVRangeParameters"
#define XML_LVDSGROUP_PARAMS_KEY					"SRVLVDSGroupParameters"
#define XML_VIRTUALTRACE_PARAMS_KEY					"SRVVirtualTraceParameters"
#define XML_MONOUT_PARAMS_KEY						"SRVMonOutParameters"
#define XML_DTSPECTRUM_PARAMS_KEY					"SRVDTSpectrumParameters"

#define CAEN_MCA_INVALID_INDEX						(-1)

#define NESTED_MAXLEN								(6)
#define NESTED_HANDLE_MAXLEN						(NESTED_MAXLEN * 2)


#endif
